<?php
include('../config.php');

$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = $_POST['full_name'];
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $query = $conn->prepare("
        INSERT INTO call_center_agents (full_name, phone, email, password, status)
        VALUES (?, ?, ?, ?, 'active')
    ");

    $query->bind_param("ssss", $full_name, $phone, $email, $password);

    if ($query->execute()) {
        $message = "Agent created successfully!";
    } else {
        $message = "Error creating agent: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Add Call Center Agent</title>
</head>
<body>

<h2>Add New Call Center Agent</h2>

<p style="color: green;"><?= $message ?></p>

<form method="POST">
    <label>Full Name</label><br>
    <input type="text" name="full_name" required><br><br>

    <label>Phone</label><br>
    <input type="text" name="phone" required><br><br>

    <label>Email</label><br>
    <input type="email" name="email" required><br><br>

    <label>Password</label><br>
    <input type="password" name="password" required><br><br>

    <button type="submit">Add Agent</button>
</form>

</body>
</html>
